<?php
// Pārliecinieties, ka sesija ir sākta
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}
?>

<!DOCTYPE html>
<html lang="lv">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="author" content="Daniils Lubimcevs">
    <meta name="create date" content="19.02.2024">
    <meta name="modify author" content="Uldis Grunde-Zeiferts">
    <meta name="modify date" content="20.02.2024">
    <title>DaniilsAuto.lv</title>
    <link rel="stylesheet" href="css/menu.css"> <!-- Atsevišķais CSS fails topbar stilam -->
</head>
<body>

    <!-- Augšējā izvēlne -->
    <div class="topbar">
        <!-- Vispārējās pogas, kas vienmēr tiek rādītas -->
        <a href="index.php"><button class="header-button" id="button1">Sākums</button></a>
        <a href="add.php"><button class="header-button" id="button2">Iesniegt sludinājumu</button></a>
        <a href="main.html"><button class="header-button" id="button3">Mani sludinājumi</button></a>
        <a href="search.html"><button class="header-button" id="button4">Meklēšana</button></a>

        <!-- Dinamiskās pogas atkarībā no lietotāja statusa -->
        <div class="auth-buttons">
            <?php if (!isset($_SESSION['user'])): ?>
                <!-- Ja lietotājs nav pieteicies -->
                <a href="login.php"><button class="header-button" id="login-button">Pieslēgties</button></a>
                <a href="register.php"><button class="header-button" id="register-button">Reģistrēties</button></a>
            <?php else: ?>
                <!-- Ja lietotājs ir pieteicies -->
                <button class="header-button" id="user-button">Sveiks, <?php echo htmlspecialchars($_SESSION['user']); ?>!</button>
                <a href="logout.php"><button class="header-button" id="logout-button">Iziet</button></a>
            <?php endif; ?>
        </div>
    </div>

    <!-- Lapas saturs -->
    <div class="content">
    </div>

</body>
</html>
